package LWP::Protocol::https::hosts;

use strict;
use warnings;
use parent 'LWP::Protocol::https';
use LWP::UserAgent::DNS::Hosts;

sub _extra_sock_opts {
    my ($self, $host, $port) = @_;

    my @opts = $self->SUPER::_extra_sock_opts($host, $port);
    if (my $peer_addr = LWP::UserAgent::DNS::Hosts->_registered_peer_addr($host)) {
        push @opts, (
            PeerAddr          => $peer_addr,
            Host              => $host,
            SSL_verifycn_name => $host,
            SSL_hostname      => $host, # for SNI
        );
    }

    return @opts;
}

sub socket_class { 'LWP::Protocol::https::Socket' }

1;

=encoding utf-8

=head1 NAME

LWP::Protocol::https::hosts - Extends LWP::Protocol::https

=head1 SYNOPSIS

to allow override of HTTPS request peer addresses when using
LWP::UserAgent.

=head1 DESCRIPTION

LWP::Protocol::https::hosts extends LWP::Protocol::https to allow override of
HTTPS request with peer addresses and hosts using LWP::UserAgent::DNS::Hosts.

=head1 METHODS

=over 4

=item _extra_sock_opts

=item socket_class

=back

=head1 AUTHOR
   
NAKAGAWA Masaki E<lt>masaki@cpan.orgE<gt>

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

__END__
