% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldecomp.R
\name{ldecomp}
\alias{ldecomp}
\title{Class for storing and visualising linear decomposition of dataset (X = TP' + E)}
\usage{
ldecomp(scores, loadings, residuals, eigenvals, ncomp.selected = ncol(scores))
}
\arguments{
\item{scores}{matrix with score values (I x A).}

\item{loadings}{matrix with loading values (J x A).}

\item{residuals}{matrix with data residuals (I x J)}

\item{eigenvals}{vector with eigenvalues for the loadings}

\item{ncomp.selected}{number of selected components}
}
\value{
Returns an object (list) of \code{ldecomp} class with following fields:
\item{scores }{matrix with score values (I x A).}
\item{residuals }{matrix with data residuals (I x J).}
\item{T2 }{matrix with score distances (I x A).}
\item{Q }{matrix with orthogonal distances (I x A).}
\item{ncomp.selected }{selected number of components.}
\item{expvar }{explained variance for each component.}
\item{cumexpvar }{cumulative explained variance.}
}
\description{
Creates an object of ldecomp class.
}
\details{
\code{ldecomp} is a general class for storing results of decomposition of dataset in
form X = TP' + E. Here, X is a data matrix, T - matrix with scores, P - matrix with
loadings and E - matrix with residuals. It is used, for example, for PCA results
(\code{\link{pcares}}), in PLS and other methods. The class also includes methods for
calculation of residual distances and explained variance.

There is no need to use the \code{ldecomp} manually. For example, when build PCA model
with \code{\link{pca}} or apply it to a new data, the results will automatically inherit
all methods of \code{ldecomp}.
}
