% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classmodel.R
\name{plotPredictions.classmodel}
\alias{plotPredictions.classmodel}
\title{Predictions plot for classification model}
\usage{
\method{plotPredictions}{classmodel}(
  obj,
  res.name = NULL,
  nc = seq_len(obj$nclasses),
  ncomp = NULL,
  main = NULL,
  ...
)
}
\arguments{
\item{obj}{a classification model (object of class \code{simca}, \code{plsda}, etc.). if \code{NULL} value
is specified, the result will be selected automatically by checking the nearest available from
test, cv and calibration results.}

\item{res.name}{name of result object to make the plot for ("test", "cv" or "cal").}

\item{nc}{vector with class numbers to make the plot for.}

\item{ncomp}{what number of components to make the plot for.}

\item{main}{title of the plot (if NULL will be set automatically)}

\item{...}{most of the graphical parameters from \code{\link{mdaplotg}} function can be used.}
}
\description{
Makes a plot with class predictions for a classification model.
}
\details{
See examples in description of \code{\link{plsda}}, \code{\link{simca}} or \code{\link{simcam}}.
}
