% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{setDistanceLimits.pca}
\alias{setDistanceLimits.pca}
\title{Compute and set statistical limits for Q and T2 residual distances.}
\usage{
\method{setDistanceLimits}{pca}(
  obj,
  lim.type = obj$lim.type,
  alpha = obj$alpha,
  gamma = obj$gamma,
  ...
)
}
\arguments{
\item{obj}{object with PCA model}

\item{lim.type}{type of limits ("jm", "chisq", "ddmoments", "ddrobust")}

\item{alpha}{significance level for detection of extreme objects}

\item{gamma}{significance level for detection of outliers (for data driven approach)}

\item{...}{other arguments}
}
\value{
Object models with the two fields updated.
}
\description{
Computes statisticsl limits for orthogonal and score distances (based on calibration set)
and assign the calculated values as model properties.
}
\details{
The limits can be accessed as fields of model objects: \code{$Qlim} and \code{$T2lim}. Each
is a matrix with four rows and \code{ncomp} columns. First row contains critical limits for
extremes, second row - for outliers, third row contains mean value for corresponding distance
(or its robust estimate in case of \code{lim.type = "ddrobust"}) and last row contains the
degrees of freedom.
}
